# 画面設計書 155-Cat 保留中タスク

## 概要

本ドキュメントは、OpenSearchのCat Pending Tasks API（`GET /_cat/pending_tasks`）エンドポイントに関する画面設計書である。クラスタマネージャノードでキューに入っているペンディングタスクをテーブル形式で返すAPIの仕様を定義する。

### 本画面の処理概要

**業務上の目的・背景**：クラスタマネージャノードで処理待ちとなっているクラスタ状態更新タスクを一覧形式で確認するために使用される。ペンディングタスクが多数存在する場合、クラスタのパフォーマンス問題や安定性の低下を示唆するため、クラスタの健全性監視に重要なAPIである。

**画面へのアクセス方法**：HTTPクライアントから `GET /_cat/pending_tasks` にリクエストを送信してアクセスする。

**主要な操作・処理内容**：
1. PendingClusterTasksRequestをクラスタマネージャに発行する
2. PendingClusterTasksResponseからペンディングタスク一覧を取得する
3. 各タスクの挿入順序、待機時間、優先度、ソースをテーブルとして構築する

**画面遷移**：本APIはステートレスなREST APIである。クラスタペンディングタスクAPI（`GET /_cluster/pending_tasks`）と同等の情報をテーブル形式で返す。

**権限による表示制御**：セキュリティプラグインが有効な場合、クラスタモニタリング権限が必要となる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 47 | クラスタヘルス | 関連機能 | ペンディングタスクの情報をテーブル形式で返す処理 |

## 画面種別

一覧（テーブル形式のペンディングタスク表示）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| GET | `/_cat/pending_tasks` | ペンディングタスク情報をテーブル形式で返す |

## 入出力項目

### リクエストパラメータ

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
|-------------|------|------|-----------|------|
| format | string | No | - | レスポンス形式（json, yamlなど） |
| local | boolean | No | false | ローカル情報を返す |
| cluster_manager_timeout | time | No | 30s | クラスタマネージャノードへの接続タイムアウト |
| master_timeout | time | No | 30s | **非推奨**: cluster_manager_timeoutを使用 |
| h | list | No | - | 表示するカラム名のカンマ区切りリスト |
| help | boolean | No | false | ヘルプ情報を返す |
| s | list | No | - | ソートするカラム名のカンマ区切りリスト |
| time | enum | No | - | 時間値の表示単位（d/h/m/s/ms/micros/nanos） |
| v | boolean | No | false | 冗長モード。カラムヘッダーを表示 |

## 表示項目

| カラム名 | エイリアス | 説明 | テキスト配置 |
|---------|-----------|------|-------------|
| insertOrder | o | タスクの挿入順序 | 右寄せ |
| timeInQueue | t | タスクがキュー内にある時間 | 右寄せ |
| priority | p | タスクの優先度 | - |
| source | s | タスクのソース（発生元） | - |

## イベント仕様

### 1-GETリクエスト受信

クライアントからのGETリクエストを受信すると、`RestPendingClusterTasksAction.doCatRequest()` が呼び出される。PendingClusterTasksRequestを生成し、クラスタマネージャノードにペンディングタスク一覧をリクエストする。レスポンスを受信後、`buildTable()` でテーブルを構築する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| GETリクエスト | - | SELECT | 参照のみ。データベースへの更新は発生しない |

## メッセージ仕様

| メッセージ種別 | 条件 | メッセージ内容 |
|--------------|------|-------------|
| 正常応答 | ペンディングタスク取得成功時 | テーブル形式のタスク情報 |
| 正常応答 | ペンディングタスクが0件の場合 | 空のレスポンス |

## 例外処理

- クラスタマネージャ未選出時：マスタータイムアウトエラーが返される

## 備考

- ペンディングタスクが存在しない場合、空のレスポンスが返される
- priorityはIMMMEDIATE, URGENT, HIGH, NORMAL, LOW, LANGUIDの順で優先度が高い
- insertOrderは単調増加のシーケンス番号

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | PendingClusterTask.java | `server/src/main/java/org/opensearch/cluster/service/PendingClusterTask.java` | insertOrder, timeInQueue, priority, sourceの4フィールドを保持 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestPendingClusterTasksAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestPendingClusterTasksAction.java` | Cat Pending Tasks APIのエントリーポイント |

**主要処理フロー**:
1. **行60-61**: `routes()` で `GET /_cat/pending_tasks` を登録
2. **行75-91**: `doCatRequest()` でPendingClusterTasksRequestを生成・発行
3. **行94-103**: `getTableWithHeader()` で4カラムのテーブルヘッダー定義
4. **行105-118**: `buildTable()` でペンディングタスクのイテレーション

### プログラム呼び出し階層図

```
RestPendingClusterTasksAction.doCatRequest() [行75]
    |
    +-- PendingClusterTasksRequest() [行76]
    |
    +-- client.admin().cluster().pendingClusterTasks() [行82-84]
           |
           +-- buildTable() [行105]
                  +-- getTableWithHeader() [行94]
                  +-- task.getInsertOrder() [行110]
                  +-- task.getTimeInQueue() [行111]
                  +-- task.getPriority() [行112]
                  +-- task.getSource() [行113]
```

### データフロー図

```
[入力]                      [処理]                              [出力]

GET /_cat/pending_tasks --> RestPendingClusterTasksAction      --> テーブル形式
                             |
                             v
                        PendingClusterTasksRequest
                             |
                             v
                        PendingClusterTasksResponse
                             |
                             v
                        buildTable() (タスクごとに1行)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestPendingClusterTasksAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestPendingClusterTasksAction.java` | ソース | Cat Pending Tasks APIのRESTハンドラ |
| AbstractCatAction.java | `server/src/main/java/org/opensearch/rest/action/cat/AbstractCatAction.java` | ソース | Cat API共通基底クラス |
| PendingClusterTask.java | `server/src/main/java/org/opensearch/cluster/service/PendingClusterTask.java` | ソース | ペンディングタスクデータ構造 |
| PendingClusterTasksRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/tasks/PendingClusterTasksRequest.java` | ソース | リクエストクラス |
| cat.pending_tasks.json | `rest-api-spec/src/main/resources/rest-api-spec/api/cat.pending_tasks.json` | 設定 | REST API仕様定義 |
